%% negation.m 

%% Function to compute the negation of a type-1 fuzzy set using Theorem A-3
%% in the book Uncertain Rule-Based Fuzzy Logic Systems: Introduction and
%% New Directions, by Jerry M. Mendel, and published by Prentice-Hall, 2000.

%% Written by Nilesh N. Karnik - July 21,1998
%% For use with MATLAB 5.1 or higher.

%% Outputs : "out" and "mem" (vectors) are, respectively, 
%% the domain and the memberships of the result of the "negation" 
%% operation. 
 
%% Inputs : "x" and "y" are respectively, the domain and membership 
%% grades of the type-1 set to be negated. 


function[out,mem] = negation(x,y)

out = 1 - x ;
mem = y ;

return ;











